const spawnCoords = "0 116 0"
const yOffset = 0
const seaLevel = 63

import { World, Commands } from "Minecraft";
import * as Minecraft from "Minecraft";

const dim0 = World.getDimension("overworld")
const dim1 = World.getDimension("nether")
const dim2 = World.getDimension("the end")

Minecraft.World.events.beforeChat.subscribe(eventData => {
	var playerName = eventData.sender.name;
	if (eventData.message.toLowerCase().startsWith(".spawn")) {
		Commands.run(`tp "${playerName}" ${spawnCoords}`, dim0);
		Commands.run(`tellraw "${playerName}" {"rawtext":[{"text":"§bYou have been teleported to spawn"}]}`, dim0);
		eventData.cancel = true;
	}else if (eventData.message.toLowerCase().startsWith(".depth")) {
        const pos = eventData.sender.location;
		const posY = Math.floor(pos.y - yOffset);
		const posZ = Math.floor(pos.z);
		if (posZ <= -1934427684864) {
			Commands.run(`tellraw "${playerName}" {"rawtext":[{"text":"§cError getting Location, please retry again in few seconds."}]}`, dim0);
			return;
		}
		if (posY > seaLevel) {
			let yDifference = posY - seaLevel
			Commands.run(`tellraw "${playerName}" {"rawtext":[{"text":"§6You are §a${yDifference} §6block(s) above sea level."}]}`, dim0);
		}else if (posY < seaLevel) {
			let yDifference = seaLevel - posY
			Commands.run(`tellraw "${playerName}" {"rawtext":[{"text":"§6You are §c${yDifference} §6block(s) below sea level."}]}`, dim0);
		}else Commands.run(`tellraw "${playerName}" {"rawtext":[{"text":"§6You are at sea level."}]}`, dim0);
		eventData.cancel = true;
    }else {
		//tag @s add "$(PREFIX)"
		const data = Minecraft.Commands.run(`tag ${playerName} list`, dim0);
		const allRanks = data.statusMessage.match(/(?<=\$\().+?(?=\))/g);
		if(!allRanks) return;
		eventData.cancel = true;
		return Minecraft.Commands.run(`tellraw @a {"rawtext":[{"text":"[${allRanks.join(' ').trim()}] ${playerName}: ${eventData.message}"}]}`, dim0);
	}
});
